﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Chapter3__Neapolitan_
{
    class Program
    {
        #region Question 4
        static int Bin2(int n, int k)
        {
            int[] array = new int[k + 1];
            for (int i = 0; i <= n; i++)
                for (int j = Math.Min(i, k); j >= 0; j--)
                    if (i == j || j == 0)
                        array[j] = 1;
                    else
                        array[j] += array[j - 1];
            return array[k];
        }
        #endregion
        #region Question 16
        static int parenthesizedCount(int MatrixNumber)
        {
            if (MatrixNumber == 1)
                return 1;
            else
            {
                int sum = 0;
                for (int i = 1; i <= MatrixNumber - 1; i++)
                {
                    sum += (parenthesizedCount(i) * parenthesizedCount(MatrixNumber - i));
                }
                return sum;
            }
        }
        #endregion
        #region Question 23
        static void Optimal_BST(int n, float[] p, out float minavg, out int[,] R)
        {
            float[,] A = new float[n + 2, n + 1];
            float[,] W = new float[n + 2, n + 1];
            R = new int[n + 1, n + 1];
            for (int diagonal = 0; diagonal < n; diagonal++)
            {
                for (int i = 1; i <= n - diagonal; i++)
                {
                    int j = i + diagonal;
                    A[i, j] = 1000000; // +Infinity
                    W[i, j] = W[i, j - 1] + p[j];
                    for (int k = i; k <= j; k++)
                    {
                        if (A[i, k - 1] + A[k + 1, j] + W[i, j] < A[i, j])
                        {
                            A[i, j] = A[i, k - 1] + A[k + 1, j] + W[i, j];
                            R[i, j] = k;
                        }
                    }
                }
            }
            minavg = A[1, n];
            //for (int i = 1; i < A.GetLength(0); i++)
            //{
            //    for (int j = 1; j < A.GetLength(1); j++)
            //    {
            //        Console.Write(A[i, j] + "\t");
            //    }
            //    Console.WriteLine();
            //}
            //Console.WriteLine();
            //Console.WriteLine();
            //for (int i = 1; i < R.GetLength(0); i++)
            //{
            //    for (int j = 1; j < R.GetLength(1); j++)
            //    {
            //        Console.Write(R[i, j] + "\t");
            //    }
            //    Console.WriteLine();
            //}
        }
        #endregion
        #region Question 26
        static void Optimal_BST(int n, float[] p, float[] q, out float minavg, out int[,] R)
        {
            float[,] A = new float[n + 2, n + 1];
            float[,] W = new float[n + 2, n + 1];
            R = new int[n + 1, n + 1];
            for (int i = 1; i <= n + 1; i++)
            {
                A[i, i - 1] = q[i - 1];
                W[i, i - 1] = q[i - 1];
            }
            for (int diagonal = 0; diagonal < n; diagonal++)
            {
                for (int i = 1; i <= n - diagonal; i++)
                {
                    int j = i + diagonal;
                    A[i, j] = 1000000; // +Infinity
                    W[i, j] = W[i, j - 1] + p[j] + q[j];
                    for (int k = i; k <= j; k++)
                    {
                        if (A[i, k - 1] + A[k + 1, j] + W[i, j] < A[i, j])
                        {
                            A[i, j] = A[i, k - 1] + A[k + 1, j] + W[i, j];
                            R[i, j] = k;
                        }
                    }
                }
            }
            minavg = A[1, n];
        }
        #endregion
        #region Question 32
        static void SeqAlignment(string S1, string S2, out int[,] Matrix)
        {
            int MismatchPenalty = 1, GapPenalty = 2, penalty;
            Matrix = new int[S1.Length + 1, S2.Length + 1];
            for (int i = 0; i < Matrix.GetLength(0); i++)
            {
                Matrix[i, 0] = i * GapPenalty;
            }
            for (int i = 0; i < Matrix.GetLength(1); i++)
            {
                Matrix[0, i] = i * GapPenalty;
            }
            for (int i = 1; i <= S1.Length; i++)
            {
                for (int j = 1; j <= S2.Length; j++)
                {
                    if (S1[i - 1] == S2[j - 1])
                    {
                        penalty = 0;
                    }
                    else
                    {
                        penalty = MismatchPenalty;
                    }
                    Matrix[i, j] = Math.Min(Matrix[i - 1, j - 1] + penalty, Math.Min(Matrix[i - 1, j] + GapPenalty, Matrix[i, j - 1] + GapPenalty));
                }
            }
            //for (int i = Matrix.GetLength(0) - 1; i >= 0; i--)
            //{
            //    for (int j = Matrix.GetLength(1) - 1; j >= 0 ; j--)
            //    {
            //        Console.Write(Matrix[i, j] + "\t");
            //    }
            //    Console.WriteLine();
            //}
            //Console.WriteLine();
        }
        #endregion
        #region Question 37
        static void Optimal_BST_Knuth(int n, float[] p, out float minavg, out int[,] R)
        {
            float[,] A = new float[n + 2, n + 1];
            float[,] W = new float[n + 2, n + 1];
            R = new int[n + 1, n + 1];
            for (int diagonal = 0; diagonal < n; diagonal++)
            {
                for (int i = 1; i <= n - diagonal; i++)
                {
                    int j = i + diagonal;
                    A[i, j] = 1000000; // +Infinity
                    W[i, j] = W[i, j - 1] + p[j];
                    for (int k = R[i, j - 1]; k <= R[i + 1, j]; k++)
                    {
                        if (A[i, k - 1] + A[k + 1, j] + W[i, j] < A[i, j])
                        {
                            A[i, j] = A[i, k - 1] + A[k + 1, j] + W[i, j];
                            R[i, j] = k;
                        }
                    }
                }
            }
            minavg = A[1, n];
        }
        #endregion
        #region Question 38
        static float MaxSubString(float[] number)
        {
            int n = number.Length;
            float[,] W = new float[n + 1, n + 1];
            float[,] A = new float[n + 2, n + 1];
            for (int i = 1; i < A.GetLength(0); i++)
                A[i, i - 1] = -1000000; // -Infinity
            for (int diagonal = 0; diagonal < n; diagonal++)
            {
                for (int i = 1; i <= n - diagonal; i++)
                {
                    int j = i + diagonal;
                    W[i, j] = W[i, j - 1] + number[j - 1];
                    A[i, j] = W[i, j];
                    if (A[i, j] < A[i + 1, j])
                        A[i, j] = A[i + 1, j];
                    if (A[i, j] < A[i, j - 1])
                        A[i, j] = A[i, j - 1];
                }
            }
            return A[1, n];
        }
        #endregion
        #region Question 39
        static void LCS(string S1, string S2, out int[,] Len, out char[,] PrintKey)
        {
            Len = new int[S1.Length + 1, S2.Length + 1];
            PrintKey = new char[S1.Length + 1, S2.Length + 1];
            for (int i = 1; i <= S1.Length; i++)
                for (int j = 1; j <= S2.Length; j++)
                {
                    if (S1[i - 1] == S2[j - 1])
                    {
                        Len[i, j] = Len[i - 1, j - 1] + 1;
                        PrintKey[i, j] = '\\';
                    }
                    else if (Len[i - 1, j] >= Len[i, j - 1])
                    {
                        Len[i, j] = Len[i - 1, j];
                        PrintKey[i, j] = '|';
                    }
                    else
                    {
                        Len[i, j] = Len[i, j - 1];
                        PrintKey[i, j] = '_';
                    }
                }
        }
        static void Print_LCS(char[,] PrintKey, string S1, int i, int j)
        {
            if (i > 0 && j > 0)
            {
                if (PrintKey[i, j] == '\\')
                {
                    Print_LCS(PrintKey, S1, i - 1, j - 1);
                    Console.Write(S1[i - 1]);
                }
                if (PrintKey[i, j] == '|')
                    Print_LCS(PrintKey, S1, i - 1, j);
                else if (PrintKey[i, j] == '_')
                    Print_LCS(PrintKey, S1, i, j - 1);
            }
        }
        #endregion
        static void Main(string[] args)
        {
            Console.WriteLine("-------------------------------------------------------------// 4");
            Console.WriteLine(Bin2(50, 8));
            Console.WriteLine("-------------------------------------------------------------// 16");
            Console.WriteLine("Number of states : " + parenthesizedCount(5));
            Console.WriteLine("-------------------------------------------------------------// 23,26");
            //Indices of p Array Begin from 1 so p[0]=0 and not considred in algorithm.

            //float[] p = { 0, 0.15f, 0.1f, 0.05f, 0.1f, 0.2f };
            //float[] q = { 0.05f, 0.1f, 0.05f, 0.05f, 0.05f, 0.1f };
            float[] p = { 0, 0.05f, 0.15f, 0.05f, 0.35f, 0.05f, 0.35f };
            float[] q = new float[7];
            float minavg;
            int[,] R;
            Optimal_BST(p.Length - 1, p, out minavg, out R);
            Console.WriteLine("Answer of question 23 : " + minavg);
            Optimal_BST(p.Length - 1, p, q, out minavg, out R);
            Console.WriteLine("Answer of question 26 : " + minavg);
            Console.WriteLine("-------------------------------------------------------------// 32");
            string s1 = "ACCATTGGGCC";
            string s2 = "ACTTGAGG";
            int[,] c;
            char[,] b;
            SeqAlignment(s1, s2, out c);
            Console.WriteLine("Cost : " + c[s1.Length, s2.Length]);
            Console.WriteLine("-------------------------------------------------------------// 38");
            float[] number = { 2, -6, 2, -1, 2 };
            Console.WriteLine(MaxSubString(number));
            Console.WriteLine("-------------------------------------------------------------// 39");
            s1 = "A$CMA*MN";
            s2 = "AXMC4ANB";
            //int[,] c;
            //char[,] b;
            LCS(s1, s2, out c, out b);
            Console.WriteLine("Length : " + c[s1.Length, s2.Length]);
            Print_LCS(b, s1, s1.Length, s2.Length);
            Console.WriteLine("\n-------------------------------------------------------------//");
            Console.ReadKey();
        }
        #region Print
        static void Print(int[,] array)
        {
            for (int i = 1; i < array.GetLength(0); i++)
            {
                Console.WriteLine();
                for (int j = 0; j < array.GetLength(1); j++)
                    Console.Write(array[i, j] + "   ");
            }
        }
        static void Print(float[,] array)
        {
            for (int i = 1; i < array.GetLength(0); i++)
            {
                Console.WriteLine();
                for (int j = 0; j < array.GetLength(1); j++)
                    Console.Write(array[i, j] + "   ");
            }
        }
        #endregion
    }
}
